/*
 * Copyright 2013-2014 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WIN32_MISC_H
#define _WIN32_MISC_H

#include "includes.h"

#ifdef WIN32

#undef _PATH_DEVNULL
#define _PATH_DEVNULL "nul"

#define index(s, c) strchr(s, c)

/* These are outside the normal range */
#define	S_IXGRP	0x00010000
#define	S_IWGRP	0x00020000
#define	S_IRGRP 0x00040000
#define	S_IXOTH	0x00100000
#define	S_IWOTH	0x00200000
#define	S_IROTH 0x00400000
#define	S_ISUID	0x01000000
#define	S_ISGID	0x02000000
#define	S_ISVTX 0x04000000

#define lstat(path, st) stat(path, st)

#define mkdir(path, mode) mkdir(path)

#define F_SETFD		0
#define F_GETFL		1
#define F_SETFL		2
#define F_DUPFD		3

#define FD_CLOEXEC	0x1

int isafifo(int fd);

int fcntl(int fd, int cmd, ... /* arg */ );

struct iovec {
	void  *iov_base;    /* Starting address */
	size_t iov_len;     /* Number of bytes to transfer */
};

unsigned int sleep(unsigned int seconds);

#define WIN32_ERRNO 0x80000000

static inline int get_win32_error() { int errnum=GetLastError(); \
    return errnum > WSABASEERR ? errnum : errnum | WIN32_ERRNO; }

#define strerror win32_strerror

char *win32_strerror(int errnum);

/* Should be provided by libgcc */
int getpagesize(void);

#endif /* WIN32 */

#endif /* _WIN32_MISC_H */
