/*
 * Copyright 2013-2014 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WIN32_PWD_H
#define _WIN32_PWD_H

#include "includes.h"

#ifdef WIN32

struct passwd {
	char   *pw_name;       /* username */
	char   *pw_passwd;     /* user password */
	uid_t   pw_uid;        /* user ID */
	gid_t   pw_gid;        /* group ID */
	char   *pw_gecos;      /* user information */
	char   *pw_dir;        /* home directory */
	char   *pw_shell;      /* shell program */
};

struct group {
	char   *gr_name;       /* group name */
	char   *gr_passwd;     /* group password */
	gid_t   gr_gid;        /* group ID */
	char  **gr_mem;        /* group members */
};

uid_t getuid(void);
uid_t geteuid(void);

int setuid(uid_t uid);
int seteuid(uid_t euid);

struct passwd *getpwnam(const char *name);
struct passwd *getpwuid(uid_t uid);

struct passwd *getpwent(void);
void setpwent(void);
void endpwent(void);

struct group *getgrnam(const char *name);
struct group *getgrgid(gid_t gid);

struct group *getgrent(void);
void setgrent(void);
/* endgrent() already has a stub for some reason */

gid_t getgid(void);
gid_t getegid(void);

int setgid(gid_t gid);
int setegid(gid_t egid);

int initgroups(const char *user, gid_t group);
int getgroups(int size, gid_t list[]);
int setgroups(size_t size, const gid_t *list);

#endif /* WIN32 */

#endif /* _WIN32_PWD_H */
