/*
 * Copyright 2013-2014 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WIN32_SOCKET_H
#define _WIN32_SOCKET_H

#include "includes.h"

#ifdef WIN32
#include "winerrno.h"

#define read		win32_read
#define write		win32_write

ssize_t win32_read(int fildes, void *buf, size_t nbyte);
ssize_t win32_write(int fildes, const void *buf, size_t nbyte);

#define close		win32_close

int win32_close(int fd);

#define accept		win32_accept
#define bind		win32_bind
#define connect		win32_connect
#define gethostbyaddr	win32_gethostbyaddr
#define gethostbyname	win32_gethostbyname
#define gethostname	win32_gethostname
#define getpeername	win32_getpeername
#define getprotobyname	win32_getprotobyname
#define getservbyname	win32_getservbyname
#define getsockopt	win32_getsockopt
#define getsockname	win32_getsockname
#define listen		win32_listen
#define setsockopt	win32_setsockopt
#define socket		win32_socket

int win32_accept(int socket, struct sockaddr *address, socklen_t *address_len);
int win32_bind(int socket, const struct sockaddr *address,
               socklen_t address_len);
int win32_connect(int socket, const struct sockaddr *address,
                  socklen_t address_len);
struct hostent *win32_gethostbyaddr(const void *addr, socklen_t len, int type);
struct hostent *win32_gethostbyname(const char *name);
int win32_gethostname(char *name, size_t len);
int win32_getpeername(int sockfd, struct sockaddr *addr, socklen_t *addrlen);
struct protoent *win32_getprotobyname(const char *name);
struct servent *win32_getservbyname(const char *name, const char *proto);
int win32_getsockopt(int sockfd, int level, int optname,
                     void *optval, socklen_t *optlen);
int win32_getsockname(int sockfd, struct sockaddr *addr, socklen_t *addrlen);
int win32_listen(int sockfd, int backlog);
int win32_setsockopt(int sockfd, int level, int optname,
                     const void *optval, socklen_t optlen);
int win32_socket(int domain, int type, int protocol);

#define HAVE_PSELECT
#define select		win32_select
#define pselect		win32_pselect

int win32_select(int nfds, fd_set *readfds, fd_set *writefds,
                 fd_set *exceptfds, struct timeval *timeout);
int win32_pselect(int nfds, fd_set *readfds, fd_set *writefds,
                  fd_set *exceptfds, const struct timespec *timeout,
                  const sigset_t *sigmask);

#endif /* WIN32 */

#endif /* _WIN32_SOCKET_H */
