/*
 * Copyright 2013-2014 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WIN32_STUBS_H
#define _WIN32_STUBS_H

#include "includes.h"

#ifdef WIN32

#define	LOG_CRIT	0
#define	LOG_ERR		1
#define	LOG_INFO	2
#define	LOG_DEBUG	3

#define	LOG_USER	0
#define	LOG_DAEMON	1
#define	LOG_AUTH	2

#define	LOG_LOCAL0	10
#define	LOG_LOCAL1	11
#define	LOG_LOCAL2	12
#define	LOG_LOCAL3	13
#define	LOG_LOCAL4	14
#define	LOG_LOCAL5	15
#define	LOG_LOCAL6	16
#define	LOG_LOCAL7	17

#define	LOG_PID		0x01

void openlog(const char *ident, int option, int facility);
void syslog(int priority, const char *format, ...);
void closelog(void);

pid_t fork(void);

int chown(const char *pathname, uid_t owner, gid_t group);

#undef getpgrp
pid_t getpgrp(void);
int setpgrp(pid_t pid, pid_t pgid);

int link(const char *path1, const char *path2);

int pipe(int pipefd[2]);

int getdtablesize(void);

#define WNOHANG	1

union wait {
	int w_status;
};

typedef union {
	union wait *__uptr;
	int *__iptr;
} __WAIT_STATUS __attribute__ ((__transparent_union__));

struct rusage;

pid_t wait4(pid_t pid, __WAIT_STATUS status, int options, struct rusage *rusage);

#endif /* WIN32 */

#endif /* _WIN32_STUBS_H */
