/*
 * Copyright 2013-2014 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "includes.h"

#ifdef WIN32

int
ioctl(int d, int request, ...)
{
	if (request != TIOCGWINSZ) {
		errno = EINVAL;
		return -1;
	}

	errno = EINVAL;
	return -1;
}

speed_t
cfgetispeed(const struct termios *termios_p)
{
	return B9600;
}

speed_t
cfgetospeed(const struct termios *termios_p)
{
	return B9600;
}

int
cfsetispeed(struct termios *termios_p, speed_t speed)
{
	if (speed != B9600) {
		errno = EINVAL;
		return -1;
	}

	return 0;
}

int
cfsetospeed(struct termios *termios_p, speed_t speed)
{
	if (speed != B9600) {
		errno = EINVAL;
		return -1;
	}

	return 0;
}

int
tcgetattr(int fd, struct termios *termios_p)
{
	errno = EINVAL;
	return -1;
}

int
tcsetattr(int fd, int optional_actions, const struct termios *termios_p)
{
	errno = EINVAL;
	return -1;
}

pid_t
tcgetpgrp(int fd)
{
	return getpid();
}

ssize_t
win32_read_console(int fildes, void *buf, size_t nbyte)
{
	int ret;
	HANDLE handle;
	INPUT_RECORD input[1024];
	DWORD i, out;

	/*
	 * The only way to properly read raw input from stdin is via
	 * ReadConsoleInput(). Both read() and ReadFile() have magic
	 * filtering that you cannot fully turn off.
	 *
	 * FIXME: Handle raw mode on/off
	 */

	handle = (HANDLE)_get_osfhandle(fildes);
	if (handle == INVALID_HANDLE_VALUE)
		return -1;

	ret = 0;

	while (ret == 0) {
		if (!ReadConsoleInput(handle, input, min(nbyte, 1024), &out)) {
			errno = get_win32_error();
			return -1;
		}

		for (i = 0;i < out;i++) {
			if (input[i].EventType != KEY_EVENT)
				continue;
			if (!input[i].Event.KeyEvent.bKeyDown)
				continue;
			if (input[i].Event.KeyEvent.uChar.AsciiChar == 0)
				continue;

			((char*)buf)[ret++] = input[i].Event.KeyEvent.uChar.AsciiChar;
		}
	}

	return ret;
}

int
win32_filter_console_events(HANDLE console)
{
	/* Filter out anything that doesn't generate an input character */
	while (TRUE) {
		INPUT_RECORD input;
		DWORD read;

		if (!PeekConsoleInput(console, &input, 1, &read)) {
			errno = get_win32_error();
			return -1;
		}

		if (read == 0)
			return 0;

		if ((input.EventType == KEY_EVENT) &&
		    input.Event.KeyEvent.bKeyDown &&
		    (input.Event.KeyEvent.uChar.UnicodeChar != 0))
			break;

		if (!ReadConsoleInput(console, &input, 1, &read)) {
			errno = get_win32_error();
			return -1;
		}
	}

	return 1;
}

#endif /* WIN32 */
