// -*- mode: C++; c-basic-offset: 4; -*-
//
// Copyright 2025 Cendio AB.
// For more information, see https://www.cendio.com
// Author: Samuel Mannehed <samuel@cendio.se>

#ifndef __PASSWORD_INPUT_H__
#define __PASSWORD_INPUT_H__

#include <FL/Fl_Group.H>

class Fl_Group;
class Fl_Secret_Input;
class Fl_Button;
class Fl_Pixmap;

class Fl_Password_Input: public Fl_Group {
public:
  Fl_Password_Input(int x, int y, int w, int h, const char *label);
  ~Fl_Password_Input();

  bool password_visible() const;
  void password_visible(bool visible);
  void toggle_password_visible();

  const char * value() const;
  int value(const char * t);

  int insert(const char *t, int l=0);
  void position(int x, int y);
  int take_focus();

private:
  int inp_x_offset;
  int inp_y_offset;
  int eye_x_offset;
  int eye_y_offset;

  Fl_Secret_Input * input;
  Fl_Button       * toggle_button;

  Fl_Pixmap       * open_eye_pixmap;
  Fl_Pixmap       * closed_eye_pixmap;
  Fl_Pixmap       * deactivated_eye_pixmap;

  virtual int handle(int event);

  void determine_eye_visibility();

  static void text_changed_cb(Fl_Widget *, void * w);
  static void toggle_cb(Fl_Widget *, void * w);
};

#endif
