/*
 * Copyright 2013-2014 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WIN32_AFUNIX_H
#define _WIN32_AFUNIX_H

#include "includes.h"

#ifdef WIN32

int win32_is_afunix(int fd);

int win32_afunix_close(int fd);

int win32_afunix_accept(int socket, struct sockaddr *address,
                        socklen_t *address_len);
int win32_afunix_bind(int socket, const struct sockaddr *address,
                      socklen_t address_len);
int win32_afunix_connect(int socket, const struct sockaddr *address,
                         socklen_t address_len);
int win32_afunix_listen(int sockfd, int backlog);
int win32_afunix_socket(int domain, int type, int protocol);

#endif /* WIN32 */

#endif /* _WIN32_AFUNIX_H */
