/*
 * Copyright 2013-2024 Pierre Ossman for Cendio AB
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _WIN32_SIGNAL_H
#define _WIN32_SIGNAL_H

#include "includes.h"

#include <signal.h>

#ifdef WIN32

#define	SIGHUP		(NSIG+1)
#define	SIGQUIT		(NSIG+2)
#define	SIGPIPE		(NSIG+3)
#define	SIGALRM		(NSIG+4)
#define	SIGCHLD		(NSIG+5)
#define	SIGTSTP		(NSIG+6)
#define	SIGTTIN		(NSIG+7)
#define	SIGTTOU		(NSIG+8)
#define	SIGWINCH	(NSIG+9)

#define SIG_BLOCK	0
#define SIG_UNBLOCK	1
#define SIG_SETMASK	2

typedef unsigned long long sigset_t;

struct sigaction {
	void     (*sa_handler)(int);
	sigset_t   sa_mask;
	int        sa_flags;
};

int sigaction(int sig, struct sigaction *sigact, struct sigaction *osigact);

int sigemptyset(sigset_t *mask);
int sigfillset(sigset_t *mask);

int sigaddset(sigset_t *set, int signum);
int sigdelset(sigset_t *set, int signum);

int sigismember(const sigset_t *set, int signum);

int sigprocmask(int how, const sigset_t *set, sigset_t *oldset);

int kill(pid_t pid, int sig);

unsigned int alarm(unsigned int seconds);

#endif /* WIN32 */

#endif /* _WIN32_MISC_H */