/* Copyright 2011-2021 Pierre Ossman <ossman@cendio.se> for Cendio AB
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __OPTIONSDIALOG_H__
#define __OPTIONSDIALOG_H__

#include <map>

#include <FL/Fl_Window.H>

class Fl_Widget;
class Fl_Group;
class Fl_Button;
class Fl_Check_Button;
class Fl_Round_Button;
class Fl_Input;
class Fl_Int_Input;
class Fl_Choice;
class Fl_Monitor_Arrangement;

typedef void (OptionsCallback)(void*);

class OptionsDialog : public Fl_Window {
protected:
  OptionsDialog();
  ~OptionsDialog();

public:
  static void showDialog(void);

  static void addCallback(OptionsCallback *cb, void *data = nullptr);
  static void removeCallback(OptionsCallback *cb);

  void show(void) override;

protected:
  void loadOptions(void);
  void storeOptions(void);

  void createLocalDevicesPage(int x, int y, int w, int h);
  void createOptimizationPage(int x, int y, int w, int h);
  void createSecurityPage(int x, int y, int w, int h);
  void createAdvancedPage(int x, int y, int w, int h);
  void createDisplayPage(int x, int y, int w, int h);

  static void handleAutoselect(Fl_Widget *widget, void *data);
  static void handleCompression(Fl_Widget *widget, void *data);
  static void handleJpeg(Fl_Widget *widget, void *data);

  static void handleClipboard(Fl_Widget *widget, void *data);

  static void handleFullScreenMode(Fl_Widget *widget, void *data);

  static void handleCancel(Fl_Widget *widget, void *data);
  static void handleOK(Fl_Widget *widget, void *data);

protected:
  static std::map<OptionsCallback*, void*> callbacks;

  /* Display (names match tlclient) */
  Fl_Group *display_group;
  Fl_Round_Button *windowed_button;
  Fl_Round_Button *full_screen_current_button;
  Fl_Round_Button *full_screen_all_button;
  Fl_Round_Button *selected_monitors_button;
  Fl_Monitor_Arrangement *monitor_arrangement;

  /* Local Devices (names match tlclient) */
  Fl_Check_Button *sound_checkbox;
  Fl_Button *sound_advanced_button;
  Fl_Check_Button *drives_checkbox;
  Fl_Button *drives_advanced_button;
  Fl_Check_Button *printers_checkbox;
  Fl_Button *printers_advanced_button;
  Fl_Check_Button *smartcard_checkbox;
  Fl_Button *clipboard_checkbox;

  /* Optimization */
  Fl_Check_Button *autoselectCheckbox;

  Fl_Group *encodingGroup;
  Fl_Round_Button *tightButton;
  Fl_Round_Button *zrleButton;
  Fl_Round_Button *hextileButton;
  Fl_Round_Button *rawButton;

  Fl_Group *colorlevelGroup;
  Fl_Round_Button *fullcolorCheckbox;
  Fl_Round_Button *mediumcolorCheckbox;
  Fl_Round_Button *lowcolorCheckbox;
  Fl_Round_Button *verylowcolorCheckbox;

  Fl_Check_Button *compressionCheckbox;
  Fl_Check_Button *sshCompressionCheckbox;
  Fl_Check_Button *jpegCheckbox;
  Fl_Int_Input *compressionInput;
  Fl_Int_Input *jpegInput;

  /* Security */
  Fl_Round_Button * ssh_button[3];
  Fl_Int_Input *ssh_input;

  Fl_Round_Button *password_button;
  Fl_Round_Button *pubkey_button;
  Fl_Round_Button *scpubkey_button;
  Fl_Button *smartcard_trigger_details_button;
  Fl_Round_Button *kerberos_button;

  /* Advanced */
  Fl_Check_Button *start_program_checkbox;
  Fl_Input *start_program_input;

  Fl_Check_Button *shadowing_checkbox;
  Fl_Check_Button *emulate_mb_checkbox;
  Fl_Check_Button *syskeys_checkbox;
  Fl_Choice *menukey_choice;

  Fl_Round_Button *auto_reconnect_button;
  Fl_Round_Button *ask_reconnect_button;

  Fl_Check_Button *update_checkbox;

private:
  static int fltk_event_handler(int event);
  static void handleScreenConfigTimeout(void *data);
};

#endif
