
#include "XmlRpcSource.h"
#include "XmlRpcSocket.h"
#include "XmlRpcUtil.h"

namespace XmlRpc {


  XmlRpcSource::XmlRpcSource(int writefd /*= -1*/, int readfd /*= -1*/, bool deleteOnClose /*= false*/) 
    : _writefd(writefd), _readfd(readfd), _deleteOnClose(deleteOnClose), _keepOpen(false)
  {
  }

  XmlRpcSource::~XmlRpcSource()
  {
  }


  void
  XmlRpcSource::close()
  {
    if (_writefd != -1) {
      XmlRpcUtil::log(2,"XmlRpcSource::close: closing socket %d.", _writefd);
      XmlRpcSocket::close(_writefd);
      XmlRpcUtil::log(2,"XmlRpcSource::close: done closing socket %d.", _writefd);
      _writefd = -1;
    }
    if (_readfd != -1) {
      XmlRpcUtil::log(2,"XmlRpcSource::close: closing socket %d.", _readfd);
      XmlRpcSocket::close(_readfd);
      XmlRpcUtil::log(2,"XmlRpcSource::close: done closing socket %d.", _readfd);
      _readfd = -1;
    }
    if (_deleteOnClose) {
      XmlRpcUtil::log(2,"XmlRpcSource::close: deleting this");
      _deleteOnClose = false;
      delete this;
    }
  }

} // namespace XmlRpc
